Shader "Country Indicator" {
Properties {
	_MainTex ("Base (RGB)", 2D) = "white" {}
	_Active ("Active", Float) = 0.25
	_Color ("Color", Color) = (1.0,0.6,0.6,1.0)
}
SubShader {
	Tags { "RenderType" = "Transparent" "Queue" = "Transparent" }
	Pass {
		Cull Off Lighting Off ZWrite Off
		Blend SrcAlpha OneMinusSrcAlpha
		
CGPROGRAM
#pragma fragment frag

sampler2D _MainTex;
float _Active;
float4 _CosTime;
float4 _Color;

half4 frag( float2 uv : TEXCOORD0 ) : COLOR0 {
	half diff = 0.01-abs( tex2D(_MainTex, uv).a-_Active );
	clip(diff);
	
	half a = _CosTime.w;
	
	half4 col = _Color;
	col.a = a*0.2+0.7;
	return col;
};

ENDCG
	}
}

SubShader {
	Pass {
		Cull Off Lighting Off ZWrite Off
		ColorMask 0
		SetTexture[_MainTex] { combine texture }
	}
}
}
